﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Oświadczenie ZUS Z-15</title>
		<script runat="server">

    public class Params : ContextBase {
        Context context;
        public Params(Context cx) : base(cx) {
            context = cx;
        }

        CzlonekRodziny osoba;
        [Required]
        [Priority(10)]
        [Caption("Członek rodziny")]
        public CzlonekRodziny Osoba {
            get { return osoba; }
            set { osoba = value; }
        }

        public object GetListOsoba() {
            PracHistoria ph = (PracHistoria)context[typeof(PracHistoria)];
            return ph.Pracownik.Rodzina;
        }
    }

    Params param = null;
    [Context]
    public Params Param {
        get { return param; }
        set { param = value; }
    }
  
    string NBSP(string ss) {
		return ss=="" ? "&nbsp;" : ss;
    }

    void LiczDanePracownika(PracHistoria ph) {
        bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (ph.NIP == "" || ph.PESEL == "") {
            DOKRODZAJ.EditValue = dowod ? "1" : "2";
            DOKUBEZP.EditValue = ph.Dokument.SeriaNumer;
        }
        else {
            DOKRODZAJ.EditValue = NBSP("");
            DOKUBEZP.EditValue = NBSP("");
        }
        Date ur = ph.Urodzony.Data;
        if (ur != Date.Empty)
            URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
        IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
        AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
        AdresPoczta.EditValue = adres.Poczta;
        AdresGmina.EditValue = adres.Gmina;
        AdresMiejscowosc.EditValue = adres.Miejscowosc;
        AdresUlica.EditValue = adres.Ulica;
        AdresNrDomu.EditValue = adres.NrDomu;
        AdresNrLokalu.EditValue = adres.NrLokalu;
        AdresTelefon.EditValue = adres.Telefon;
        AdresKodKraju.EditValue = adres.KodKraju;
        AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
        AdresKraj.EditValue = adres.Kraj;
        AdresMail.EditValue = "";
        if (ph.Pracownik.DomyslnyRachunek != null)
            RachunekBank.EditValue = ph.Pracownik.DomyslnyRachunek;
        else
            RachunekBank.EditValue = "&nbsp;";
    }
		
    void OnContextLoad(Object sender, EventArgs args) {
        dc.LeftMargin = dc.TopMargin = dc.RightMargin = dc.BottomMargin = 19;
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];

        LiczDanePracownika(ph);
        
        CzlonekRodziny osoba = param.Osoba;
        OsobaPESEL.EditValue = osoba.PESEL;
        bool dowod = osoba.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (osoba.NIP == "" || osoba.PESEL == "") {
            OsobaDokRodzaj.EditValue = dowod ? "1" : "2";
            OsobaDokSeria.EditValue = osoba.Dokument.SeriaNumer;
        }
        else {
            OsobaDokRodzaj.EditValue = NBSP("");
            OsobaDokSeria.EditValue = NBSP("");
        }
        OsobaNazwisko.EditValue = osoba.Nazwisko;
        OsobaImie.EditValue = osoba.Imie;
        OsobaPokrewienstwo.EditValue = osoba.StPokrewienstwa;
        Date ur = osoba.Urodzony.Data;
        if (ur != Date.Empty)
            OsobaUrodzony.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
    }
	        
    public static void Msg(object obj) {
    }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Tahoma">
		<form id="DeklaracjaZ15" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.KadryPlace"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="OŚWIADCZENIE ZUS Z-15" runat="server"></cc1:reportheader>
            <p>
                <b>CZĘŚĆ I:</b><br/>
                <b>DANE IDENTYFIKACYJNE UBEZPIECZONEGO</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">01. Numer PESEL</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Rodzaj dokumentu (1-dowód osob., 2-inny dokument)<br />
                                                       03. Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD><FONT size="2">
				            <TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					            <TR>
						            <TD width="10%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                                        <ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>
                                    </TD>
						            <TD width="2%"></TD>
						            <TD width="88%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
							            <ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel>
                                    </TD>
                                </TR>
                            </TABLE>
                        </FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">04. Nazwisko</FONT></TD>
                    </TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.Nazwisko" runat="server"></ea:DataLabel></FONT></TD>
                    </TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">05. Imię</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">06. Data urodzenia (dd/mm/rrrr)</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.Imie" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="URODZONY" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numer PESEL, a jeżeli nie nadano tego numeru, należy wpisać serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
            </P>
    	    <ea:PageBreak id="PageBreak32" runat="server" Required="False"></ea:PageBreak>
			<P>
                <b>DANE ADRESOWE UBEZPIECZONEGO – ADRES ZAMIESZKANIA</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">01. Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresPoczta" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">03. Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresGmina" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">04. Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">05. Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">06. Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">07. Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="24%"><FONT size="2">08. Numer telefonu</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="1%"></TD>
						<TD width="23%"><FONT size="2">09. Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                2) 3)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresTelefon" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKodKraju" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">10. Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                2)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">11. Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresZagranicznyKodPocztowy" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD width="48%"><FONT size="2">12. Adres poczty elektronicznej</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="AdresMail" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Podanie numeru telefonu i adresu poczty elektronicznej nie jest obowiązkowe.<br />
                    (2) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (3) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.<br />
                </span>
			</P>
    	    <ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
            <p>
                <b>Z tytułu sprawowania opieki nad:</b><br/>
                <b>DANE IDENTYFIKACYJNE DZIECKA/CZŁONKA RODZINY, NAD KTÓRYM SPRAWOWANA JEST OPIEKA</b><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">01. Numer PESEL</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Rodzaj dokumentu (1-dowód osob., 2-inny dokument)<br />
                                                       03. Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel ID="OsobaPESEL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD><FONT size="2">
				            <TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					            <TR>
						            <TD width="10%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                                        <ea:DataLabel id="OsobaDokRodzaj" runat="server"></ea:DataLabel>
                                    </TD>
						            <TD width="2%"></TD>
						            <TD width="88%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
							            <ea:DataLabel id="OsobaDokSeria" runat="server"></ea:DataLabel>
                                    </TD>
                                </TR>
                            </TABLE>
                        </FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">04. Nazwisko</FONT></TD>
                    </TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel ID="OsobaNazwisko" runat="server"></ea:DataLabel></FONT></TD>
                    </TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">05. Imię</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel ID="OsobaImie" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">06. Stopień pokrewieństwa</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">07. Data urodzenia (dd/mm/rrrr)</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel ID="OsobaPokrewienstwo" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel ID="OsobaUrodzony" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numer PESEL, a jeżeli nie nadano numeru, należy wpisać serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
            </p>
    	    <ea:PageBreak id="PageBreak4" runat="server" Required="False"></ea:PageBreak>
            <p>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
                        <TD width="12%"><FONT size="2">za okres od:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="3%"><FONT size="2">do:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="23%"><FONT size="2">seria i numer zaśw. lek. [1]&nbsp;</FONT></TD>
						<TD width="22%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                    </TR>
                </TABLE>
            </p>
    	    <ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>
            <b>CZĘŚĆ II:</b><br/>
			<FONT face="Tahoma" size="2">
                Oświadczam, że:
                <OL>
                    <li value="1">
                        Jest / nie ma domownik(a) mogący(ego) zapewnić opiekę w okresie . . . . . . . . . . . . . . . . . . . . . . . . .
			    </OL>	
			</FONT>
			<ea:PageBreak id="PageBreak5" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <OL>
                    <li value="2">
                        Jestem
				        <ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="PracHistoria.Plec">
					        <ValuesMap>
						        <ea:ValuesPair Key="Kobieta" Value="zatrudniona / nie jestem zatrudniona"></ea:ValuesPair>
						        <ea:ValuesPair Key="Mężczyzna" Value="zatrudniony / nie jestem zatrudniony"></ea:ValuesPair>
					        </ValuesMap>
				        </ea:DataLabel>
                        w systemie pracy zmianowej w godzinach [2]<br />
                        . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
			    </OL>	
			</FONT>
			<ea:PageBreak id="PageBreak7" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <OL>
                    <li value="3">
                        Matka dziecka / ojciec dziecka / małżonek(a)<br />
                        1) pracuje / nie pracuje<br />
                        2) wykonuje pracę / nie wykonuje pracy w systemie pracy zmianowej<br />
                        Jeżeli TAK, podać w jakich godzinach . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
			    </OL>	
			</FONT>
			<ea:PageBreak id="PageBreak8" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <OL>
                    <li value="4">
                        W danym roku kalendarzowym wypłacono mi zasiłek opiekuńczy z tytułu poprzedniego ubezpieczenia:
                        TAK / NIE<br />
                        — z tytułu opieki nad dziećmi w wieku do 14 lat za . . . . . . . . dni,<br />
                        — z tytułu opieki nad chorymi dziećmi w wieku powyżej 14 lat lub chorym członkiem rodziny za . . . . dni,<br />
                </ol>
			</FONT>
    	    <ea:PageBreak id="PageBreak9" runat="server" Required="False"></ea:PageBreak>
    		<FONT face="Tahoma" size="2">
                <b>NAZWA I ADRES POPRZEDNIEGO PŁATNIKA SKŁADEK:</b><br />
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="100%"><FONT size="2">Nazwa płatnika składek:</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel14" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel1" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel2" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel3" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel4" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel6" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                1) 2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel7" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel8" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel10" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel11" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel12" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (2) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.
                </span>
			</FONT>
			<ea:PageBreak id="PageBreak6" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <OL>
                    <li value="5">
                        W danym roku kalendarzowym matka dziecka / ojciec dziecka / małżonek(a)<br />
                </OL>
                <b>DANE WYMIENIONEJ OSOBY:</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">Numer PESEL</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Rodzaj dokumentu (1-dowód osob., 2-inny dokument)<br />
                                                       Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="DataLabel15" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
                            <ea:DataLabel id="DataLabel9" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DataLabel13" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">Nazwisko</FONT></TD>
                    </TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="DataLabel16" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
                    </TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">Imię</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="DataLabel17" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numer PESEL, a jeżeli nie nadano tego numeru, należy wpisać serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
            </FONT>
			<ea:PageBreak id="PageBreak12" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <p>
                    pobrał(a) zasiłek opiekuńczy: TAK / NIE<br />
                    — z tytułu opieki nad dziećmi w wieku do 14 lat za . . . . . . . . . dni,</br>
                    — z tytułu opieki nad chorymi dziećmi w wieku powyżej 14 lat lub chorym członkiem rodziny za . . . . .dni,<br />
                </p>
            </FONT>
			<ea:PageBreak id="PageBreak14" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <b>NAZWA I ADRES PŁATNIKA SKŁADEK WYMIENIONEJ OSOBY:</b><br />
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="100%"><FONT size="2">Nazwa płatnika składek:</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel33" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel18" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel19" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel20" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel21" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel22" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                1) 2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel23" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel24" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel25" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel26" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel27" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (2) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.
                </span>
			</FONT>
			<ea:PageBreak id="PageBreak10" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <OL>
                    <li value="6">
                        W danym roku kalendarzowym inny członek rodziny:<br />
                </OL>
                <b>DANE CZŁONKA RODZINY:</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">Numer PESEL</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Rodzaj dokumentu (1-dowód osob., 2-inny dokument)<br />
                                                       Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="DataLabel28" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
                            <ea:DataLabel id="DataLabel29" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DataLabel30" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">Nazwisko</FONT></TD>
                    </TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="DataLabel31" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
                    </TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">Imię</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="DataLabel32" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numer PESEL, a jeżeli nie nadano tego numeru, należy wpisać serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
			</FONT>
			<ea:PageBreak id="PageBreak13" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <p>
                    pobrał zasiłek opiekuńczy: TAK / NIE<br />
                    — z tytułu opieki nad dzieckiem w wieku do 8. tygodnia życia za . . . . . . . . . dni,<br />
                    — z tytułu opieki nad chorym członkiem rodziny za . . . . . . . . dni.<br />
			    </p>	
			</FONT>
			<ea:PageBreak id="PageBreak15" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <b>NAZWA I ADRES PŁATNIKA SKŁADEK INNEGO CZŁONKA RODZINY:</b><br />
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="100%"><FONT size="2">Nazwa płatnika składek:</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel44" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel34" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel35" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel36" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel37" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel38" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                1) 2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel39" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel40" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel41" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel42" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="DataLabel43" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (2) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.
                </span>
			</FONT>
			<ea:PageBreak id="PageBreak11" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
                <OL>
                    <li value="7">
                        Pozostaję / nie pozostaję we wspólnym gospodarstwie domowym z wymienionym wyżej dzieckiem w wieku
                        powyżej 14 lat lub z innym chorym członkiem rodziny.
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak17" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
            <p>
				Proszę o wypłatę zasiłku opiekuńczego na rachunek bankowy nr:
				<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="92%" border="0" style="font-size: 10pt; font-family: tahoma">
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        	<ea:DataLabel id="RachunekBank" runat="server"></ea:DataLabel>
						</TD>
					</TR>
                </TABLE>
            </p>
			</FONT>
			<ea:PageBreak id="PageBreak16" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
            <p>
                Uwagi:<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
            </p>
			</FONT>
			<ea:PageBreak id="PageBreak18" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="(Miejscowość)" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="(Data: dd/mm/rrrr)" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="(Podpis ubezpieczonego)" Width="33"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
            <br/><br/>
			</FONT>
			<ea:PageBreak id="PageBreak1" runat="server" Required="True"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<P style="text-align: center"><FONT size="3"><b>POUCZENIE</b></FONT></P>
            <p style="text-align: justify">
                <b>Podstawa prawna: ustawa z dnia 25 czerwca 1999 r. o świadczeniach pieniężnych z ubezpieczenia społecznego w razie
choroby i       macierzyństwa (Dz.U. z 2016 r. poz. 372).</b><br />
                Zasiłek opiekuńczy przysługuje osobie podlegającej ubezpieczeniu chorobowemu z tytułu sprawowania opieki nad dzieckiem
                w wieku do ukończenia 8 lat, chorym dzieckiem w wieku do ukończenia 14 lat oraz innym członkiem rodziny.
                Za członków rodziny uważa się małżonka, rodziców,rodzica dziecka, ojczyma, macochę, teściów, dziadków, wnuki,
                rodzeństwo oraz dzieci w wieku powyżej 14 lat, pod warunkiem, że w okresie sprawowania opieki pozostają we wspólnym
                gospodarstwie domowym z ubezpieczonym.<br />
                Zasiłek opiekuńczy z tytułu opieki nad dziećmi i innymi członkami rodziny przysługuje łącznie przez okres do 60 dni
                w roku kalendarzowym. Z tytułu opieki nad innymi chorymi czlonkami rodziny, w tym chorym dzieckiem w wieku powyżej 14 lat,
                zasiłek opiekuńczy przysługuje przez okres 14 dni w roku kalendarzowym.
                Jest to wymiar przysługujący bez względu na liczbę dzieci oraz niezależny od liczby innych członków rodziny wymagających opieki,
                jak również od liczby osób uprawnionych do zasiłku opiekuńczego.<br />
                W przypadku, gdy ubezpieczona matka dziecka, która pobiera zasiłek macierzyński w wymiarze 8 tygodni po porodzie,
                przebywa w szpitalu albo w innym przedsiębiorstwie podmiotu leczniczego wykonującego działalność leczniczą w rodzaju
                stacjonarne i całodobowe świadczenia zdrowotne, albo legitymuje się orzeczeniem o niezdolności do samodzielnej egzystencji
                i stan zdrowia uniemożliwia jej sprawowanie osobistej opieki nad dzieckiem, albo porzuciła dziecko, ubezpieczonemu ojcu
                dziecka przysługuje dodatkowy zasiłek opiekuńczy z tytułu osobistego sprawowania opieki nad dzieckiem, w wymiarze
                do 8 tygodni, tj. 56 dni, nie dłużej niż do ukończenia przez dziecko 8 tygodnia życia. Wymiar zasiłku opiekuńczego w takim przypadku
                nie jest związany z rokiem kalendarzowym i jest niezależny od wymiaru określonego wyżej (60 i 14 dni).
                Przepis ten ma zastosowanie także do innego ubezpieczonego członka najbliższej rodziny, jeżeli przerwie zatrudnienie lub inną działalność
                zarobkową w celu sprawowania osobistej opieki nad dzieckiem.<br />
                Zasiłek opiekuńczy przysługuje pod warunkiem, że nie ma innych domowników mogących zapewnić opiekę dziecku lub innemu choremu członkowi
                rodziny. Warunek ten nie dotyczy opieki sprawowanej nad chorym dzieckiem w wieku do ukończenia 2 lat (w takim przypadku punkt 1 wniosku
                nie musi być wypełniony).<br />
                Zasiłek opiekuńczy nie przysługuje:<br />
                - w okresie urlopu bezpłatnego lub urlopu wychowawczego,<br />
                - w okresie tymczasowego aresztowania lub odbywania kary pozbawienia wolności, z wyjątkiem przypadków, w których prawo
                do zasiłku wynika z ubezpieczenia chorobowego osób wykonujących odpłatnie pracę na podstawie skierowania do pracy w czasie
                odbywania kary pozbawienia wolności lub tymczasowego aresztowania,<br />
                - za okres objęty zaświadczeniem lekarskim, w przypadku wykonywania w czasie zwolnienia lekarskiego pracy zarobkowej albo
                wykorzystywania zwolnienia lekarskiego od pracy niezgodnie z celem tego zwolnienia,<br />
                - za okres, w którym zaświadczenie lekarskie straciło ważność wskutek kontroli prawidłowości orzekania i wystawiania zaświadczeń lekarskich.<br />
                <b>Uwaga:</b><br />
                Wniosek o zasiłek opiekuńczy należy złożyć płatnikowi zasiłku przy każdorazowym ubieganiu się o zaiłek opiekuńczy, z wyjątkiem nieprzerwanych
                okresów sprawowania opieki nad tym samym dzieckiem lub członkiem rodziny.<br />
                Ubezpieczony jest zobowiązany poinformować płatnika zasiłku o okolicznościach, które uległy zmianie w stosunku do podanych we wniosku o zasiłek opiekuńczy.<br />
                Jeżeli płatnikiem zasiłku jest ZUS i podstawą do ustalenia uprawnień do zasiłu opiekuńczego za nieprzerwany okres sprawowania opieki nad tym samym chorym dzieckiem
                lub chorym członkiem rodziny jest zaświadczenie lekarskie wystawione w formie dokumentu elektronicznego e-ZLA, ubezpieczony składając wniosek o zasiłek opiekuńczy
                wypełnia tylko Część I wniosku.<br />
			</p>
            <p>
                <span style="font-size: 9pt">
                    [1] Wypełnić w przypadku zasiłku opiekuńczego z tytułu opieki nad chorym dzieckiem lub chorym innym członkiem rodziny, gdy podstawą do ustalenia uprawnień do zasiłku jest zaświadczenie lekarskie wystawione w formie dokumentu elektronicznego e-ZLA.<br />
                    [2] Wypełnia tylko osoba, której zasiłek opiekuńczy wypłaca ZUS.<br />
                </span>
            </p>
            <p>
                <strong><span style="font-size: 2px"><span style="font-size: 9pt">ZUS-Z15<font size="2"><span></span></font></span></span></strong>
            </p>
            </FONT>
		</form>
	</body>
</HTML>
